/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PSUData {
    private final UUID uuid;
    private PSUTier tier;
    private final PSUItemHandler inventory;
    private final LazyOptional<IItemHandler> optional;
    public final Metadata meta = new Metadata();

    public PSUData(UUID uuidIn, PSUTier tierIn) {
        this.uuid = uuidIn;
        this.tier = tierIn;
        this.inventory = new PSUItemHandler(this.tier);
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public PSUData(UUID uuidIn, CompoundTag incomingNBT) {
        this.uuid = uuidIn;
        this.tier = PSUTier.values()[Math.min(incomingNBT.m_128451_("Tier"), PSUTier.TIER4.ordinal())];
        this.inventory = new PSUItemHandler(this.tier);
        this.inventory.deserializeNBT(incomingNBT.m_128469_("Inventory"));
        this.optional = LazyOptional.of(() -> this.inventory);
        if (incomingNBT.m_128441_("Metadata")) {
            this.meta.deserializeNBT(incomingNBT.m_128469_("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public PSUItemHandler getHandler() {
        return this.inventory;
    }

    public void upgrade(PSUTier newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier);
        }
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public PSUTier getTier() {
        return this.tier;
    }

    public static Optional<PSUData> fromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("UUID")) {
            UUID uuid = nbt.m_128342_("UUID");
            return Optional.of(new PSUData(uuid, nbt));
        }
        return Optional.empty();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UUID", this.uuid);
        nbt.m_128359_("StringUUID", this.uuid.toString());
        nbt.m_128405_("Tier", this.tier.ordinal());
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("Metadata", (Tag)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("firstPlayer", this.firstAccessedPlayer);
            nbt.m_128356_("firstTime", this.firstAccessedTime);
            nbt.m_128359_("lastPlayer", this.lastAccessedPlayer);
            nbt.m_128356_("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.m_128461_("firstPlayer");
            this.firstAccessedTime = nbt.m_128454_("firstTime");
            this.lastAccessedPlayer = nbt.m_128461_("lastPlayer");
            this.lastAccessedTime = nbt.m_128454_("lastTime");
        }
    }
}

